﻿Partial Public Class MainPage
    Inherits PhoneApplicationPage
    Public Sub New()
        InitializeComponent()
    End Sub


    Private Sub OnLoaded(ByVal sender As Object, ByVal args As RoutedEventArgs) Handles Me.Loaded
        Dim center As New Point(ContentPanel.ActualWidth / 2, ContentPanel.ActualHeight / 2)
        Dim radius = Math.Min(center.X - 1, center.Y - 1)

        Dim polyline As New Polyline()
        polyline.Stroke = TryCast(Me.Resources("PhoneForegroundBrush"), Brush)
        polyline.StrokeThickness = CDbl(Me.Resources("PhoneStrokeThickness"))

        For angle = 0 To 3599.75 Step 0.25
            Dim scaledRadius = radius * angle / 3600
            Dim radians = Math.PI * angle / 180
            Dim x = center.X + scaledRadius * Math.Cos(radians)
            Dim y = center.Y + scaledRadius * Math.Sin(radians)
            polyline.Points.Add(New Point(x, y))
        Next angle
        ContentPanel.Children.Add(polyline)
    End Sub
End Class

